VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBuffer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'************************************
'**       MADE WITH MIRAGEMUD      **
'#       Maintained by Xlithan     #'
'************************************
Option Explicit

' This class will be used for building packets
Private Buffer()   As Byte        ' Our byte array to hold all data

Private buffersize As Long      ' Used to keep track of how big our buffer is

Private WriteHead  As Long       ' This is used for holding our position in the byte array when writing variables

Private ReadHead   As Long        ' This is used for holding our position in the byte array when reading variables

Private Sub Class_Initialize()
    Flush
End Sub

Public Sub PreAllocate(ByVal nLength As Long)
    WriteHead = 0
    ReadHead = 0
    buffersize = nLength - 1
    ReDim Buffer(0 To buffersize)
End Sub

Public Sub Allocate(ByVal nLength As Long)

    If buffersize = 0 And nLength > 1 Then nLength = nLength - 1
    buffersize = buffersize + nLength
    ReDim Preserve Buffer(0 To buffersize)
End Sub

Public Sub Flush()
    WriteHead = 0
    ReadHead = 0
    buffersize = 0
    ReDim Buffer(0)
End Sub

Public Sub Trim()

    ' If the readhead is past the buffersize, this means everything has been read in the array, flush it
    If ReadHead >= count Then
        Flush
    End If

End Sub

Public Sub WriteByte(ByVal nByte As Byte)
    
    If WriteHead > buffersize Then Allocate 1
    
    Buffer(WriteHead) = nByte
    WriteHead = WriteHead + 1
End Sub

Public Sub WriteBytes(ByRef nByte() As Byte)

    Dim nLength As Long
    
    nLength = (UBound(nByte) - LBound(nByte)) + 1
    
    If WriteHead + nLength - 1 > buffersize Then Allocate nLength
    
    CopyMemory Buffer(WriteHead), nByte(0), nLength
    WriteHead = WriteHead + nLength
End Sub

Public Sub WriteInteger(ByVal nInteger As Integer)
    
    If WriteHead + 1 > buffersize Then Allocate 2
    
    CopyMemory Buffer(WriteHead), nInteger, 2
    WriteHead = WriteHead + 2
End Sub

Public Sub WriteLong(ByVal nLong As Long)
    
    If WriteHead + 3 > buffersize Then Allocate 4
    
    CopyMemory Buffer(WriteHead), nLong, 4
    WriteHead = WriteHead + 4
End Sub

Public Sub WriteString(ByRef nString As String)

    Dim sBytes() As Byte

    Dim sLength  As Integer
    
    sLength = Len(nString)
    sBytes = StrConv(nString, vbFromUnicode)
    
    WriteInteger sLength
    
    If sLength <= 0 Then Exit Sub
    
    If WriteHead + sLength - 1 > buffersize Then Allocate sLength
    
    CopyMemory Buffer(WriteHead), sBytes(0), sLength
    WriteHead = WriteHead + sLength
End Sub

Public Function ReadByte(Optional MoveReadHead As Boolean = True) As Byte
    
    If ReadHead > buffersize Then Exit Function
    
    ReadByte = Buffer(ReadHead)

    If MoveReadHead Then ReadHead = ReadHead + 1
End Function

Public Function ReadBytes(ByVal nLength As Long, _
                          Optional MoveReadHead As Boolean = True) As Byte()

    Dim Data() As Byte
    
    If nLength = 0 Then Exit Function
    If ReadHead + nLength - 1 > buffersize Then Exit Function
    
    ReDim Data(nLength - 1)
    
    CopyMemory Data(0), Buffer(ReadHead), nLength

    If MoveReadHead Then ReadHead = ReadHead + nLength
    
    ReadBytes = Data
End Function

Public Function ReadInteger(Optional MoveReadHead As Boolean = True) As Integer
    
    If ReadHead + 1 > buffersize Then Exit Function
    
    CopyMemory ReadInteger, Buffer(ReadHead), 2

    If MoveReadHead Then ReadHead = ReadHead + 2
End Function

Public Function ReadLong(Optional MoveReadHead As Boolean = True) As Long
    
    If ReadHead + 3 > buffersize Then Exit Function
    
    CopyMemory ReadLong, Buffer(ReadHead), 4

    If MoveReadHead Then ReadHead = ReadHead + 4
End Function

Public Function ReadString(Optional MoveReadHead As Boolean = True) As String

    Dim sLength  As Integer

    Dim sBytes() As Byte
    
    sLength = ReadInteger

    If sLength <= 0 Then Exit Function
    
    ReDim sBytes(sLength - 1)
    
    CopyMemory sBytes(0), Buffer(ReadHead), sLength
    
    ReadString = StrConv(sBytes, vbUnicode)

    If MoveReadHead Then ReadHead = ReadHead + sLength
End Function

Public Function count() As Long
    count = (UBound(Buffer) - LBound(Buffer)) + 1
End Function

Public Function length() As Long
    length = count - ReadHead
End Function

Public Function ToArray() As Byte()
    ToArray = Buffer()
End Function

Public Function ToString() As String
    ToString = StrConv(Buffer, vbUnicode)
End Function
